<?php defined('SYSPATH') or die('No direct script access.');

class Task_Helper{

    public static function getStorageClient(){
        return Task_Helper::getInitClient(
            'init.ip.storage'
        );
    }

    public static function getInitClient($config_name){
        return Task_Helper::getClient(
            Kohana::$config->load($config_name)
        );
    }

    public static function getClient($host){
        $client = new GearmanClient();
        $client->addServer($host, 4730);

        return $client;
    }

    public static function createWorker($name, &$class, $function = 'Worker', $count = 1000){
        Kohana::$profiling = false;
        Log::$write_on_add = true;

        $worker = new GearmanWorker();
        $worker->addServer(Kohana::$config->load('init.ip.gearman'), 4730);
        $worker->addFunction($name, [$class, $function]);
        for($i = 0; $i < $count; $i++){
            $worker->work();
        }
    }
}
